(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     38719,        879]
NotebookOptionsPosition[     35264,        823]
NotebookOutlinePosition[     35613,        838]
CellTagsIndexPosition[     35570,        835]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Exponential", " ", 
    RowBox[{"Window", "/", "Filter"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"exposmooth", "[", 
     RowBox[{"y0_", ",", "lrw0_", ",", "alfa0_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"y", "=", "y0"}], ",", 
        RowBox[{"lrw", "=", "lrw0"}], ",", " ", 
        RowBox[{"alfa", "=", "alfa0"}], ",", "xw", ",", "w", ",", "ys"}], 
       "}"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"x", " ", "is", " ", "not", " ", "entered", " ", "here"}], 
        ",", " ", 
        RowBox[{"it", " ", "is", " ", "assumed", " ", "equidsitant"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"xw", "=", " ", 
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "lrw"}], ",", "lrw"}], "]"}], "]"}], "/", "lrw"}]}], 
       ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"is", " ", "a", " ", 
          RowBox[{"list", ":", " ", 
           RowBox[{"lenght", "\[Equal]", "lrw"}]}]}], ",", " ", 
         RowBox[{"range", "\[Equal]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"w", " ", "=", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "alfa"}], "*", " ", 
          RowBox[{"xw", "^", "2"}]}], "]"}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{"exponential", " ", "weights"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"w", " ", "/=", " ", 
        RowBox[{"Total", "[", "w", "]"}]}], " ", ";", 
       RowBox[{"(*", " ", 
        RowBox[{"NORMALIZED", " ", "exponential", " ", "weight"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"ys", " ", "=", " ", 
        RowBox[{"ListCorrelate", "[", 
         RowBox[{"w", ",", "y"}], "]"}]}], ";", " ", 
       RowBox[{"(*", " ", "y_smooth", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"{", 
         RowBox[{"ys", ",", "w"}], "}"}], "]"}]}]}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "dimension", " ", "ys", " ", "has", " ", "been", " ", "reduced"}], ",",
        " ", 
       RowBox[{
       "and", " ", "you", " ", "need", " ", "to", " ", "find", " ", "the", 
        " ", "corresponding", " ", "xs", " ", "externally"}]}], " ", "*)"}], 
     "\[IndentingNewLine]", "]"}]}], "\n"}]}]], "Input",
 CellChangeTimes->{{3.7072125818706956`*^9, 3.7072127447965026`*^9}, {
   3.707212787209674*^9, 3.707212831332141*^9}, {3.7072128775095434`*^9, 
   3.707212941350082*^9}, 3.707212992961167*^9, {3.707213083258198*^9, 
   3.707213162115378*^9}, {3.7072134852311726`*^9, 3.70721354400066*^9}, {
   3.7072140367416353`*^9, 3.7072140813324013`*^9}, {3.707214172702115*^9, 
   3.7072142076785326`*^9}, 
   3.707214389297759*^9},ExpressionUUID->"35c10509-c0d9-46f3-b5c0-\
d52cb7e365d7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"exposmoothxy", "[", 
    RowBox[{"x0_", ",", "y0_", ",", "lrw0_", ",", "alfa0_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "=", "x0"}], ",", 
       RowBox[{"y", "=", "y0"}], ",", 
       RowBox[{"lrw", "=", "lrw0"}], ",", " ", 
       RowBox[{"alfa", "=", "alfa0"}], ",", "xw", ",", "w", ",", "ys", ",", 
       "xs", ",", "lw"}], "}"}], ",", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"x", " ", "&"}], " ", "corresponding", " ", "y", " ", "are", 
       " ", "entered", " ", "as", " ", "vectors"}], " ", "*)"}], " ", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"xw", "=", " ", 
       RowBox[{
        RowBox[{"N", "[", 
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{"-", "lrw"}], ",", "lrw"}], "]"}], "]"}], "/", "lrw"}]}], 
      ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"is", " ", "a", " ", 
         RowBox[{"list", ":", " ", 
          RowBox[{"lenght", "\[Equal]", "lrw"}]}]}], ",", " ", 
        RowBox[{
         RowBox[{"always", " ", "in", " ", "the", " ", "range"}], "\[Equal]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], " ", "-", " ", 
          RowBox[{
          "that", " ", "range", " ", "is", " ", "not", " ", 
           "important"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"w", " ", "=", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "alfa"}], "*", " ", 
         RowBox[{"xw", "^", "2"}]}], "]"}]}], ";", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"exponential", " ", 
          RowBox[{"weights", " ", "--"}], " ", "dimensions", " ", "of", " ", 
          "w"}], " ", "&"}], " ", "xw", " ", "is", " ", "always", " ", 
        "odd"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"w", " ", "/=", " ", 
       RowBox[{"Total", "[", "w", "]"}]}], " ", ";", 
      RowBox[{"(*", " ", 
       RowBox[{"NORMALIZED", " ", "exponential", " ", "weight"}], " ", "*)"}],
       "\[IndentingNewLine]", 
      RowBox[{"ys", " ", "=", " ", 
       RowBox[{"ListCorrelate", "[", 
        RowBox[{"w", ",", "y"}], "]"}]}], ";", " ", 
      RowBox[{"(*", " ", "y_smooth", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "lw", "}"}], "=", 
       RowBox[{"Dimensions", "[", "w", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xs", "=", 
       RowBox[{"Take", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"lw", "+", "1"}], ")"}], "/", "2"}], ",", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{"lw", "+", "1"}], ")"}]}], "/", "2"}]}], "}"}]}], 
        "]"}]}], ";", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{"corresponding", " ", "x", " ", "position"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Return", "[", 
       RowBox[{"{", 
        RowBox[{"xs", ",", "ys", ",", "xw", ",", "w"}], "}"}], "]"}]}]}], 
    "  ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
       "dimensions", " ", "of", " ", "xs", " ", "and", " ", "ys", " ", "have",
         " ", "been", " ", 
        RowBox[{"reduced", " ", "--"}], " ", "they", " ", "are", " ", 
        "smaller", " ", "than", " ", "x"}], " ", "&"}], " ", "y"}], "*)"}], 
    "\[IndentingNewLine]", "]"}]}], "\n"}]], "Input",
 CellChangeTimes->{{3.7072132462326403`*^9, 3.707213311256178*^9}, {
   3.7072133436042137`*^9, 3.7072134753827877`*^9}, {3.70721354887589*^9, 
   3.7072136069811115`*^9}, {3.70721390289097*^9, 3.707213935450689*^9}, {
   3.7072139735741067`*^9, 3.70721397405853*^9}, {3.707214009562029*^9, 
   3.707214028600624*^9}, {3.7072140984503717`*^9, 3.707214106858686*^9}, 
   3.7072143956521254`*^9, {3.7072146436328306`*^9, 
   3.7072146466173778`*^9}},ExpressionUUID->"75a45e71-e0f4-4c5a-9015-\
e810eddac226"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"npts", "=", "25"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8611791284240355`*^9, 
  3.861179139225905*^9}},ExpressionUUID->"02bebe18-06b1-4c33-9e74-\
554774b981fe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"1.", "*", 
      RowBox[{
       RowBox[{"Exp", "[", "i", "]"}], "/", 
       RowBox[{"i", "^", "4"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "npts"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8608328347497*^9, 3.860832921673503*^9}, {
  3.8611791491545477`*^9, 3.8611791508979177`*^9}, {3.8611792444266787`*^9, 
  3.8611792495462804`*^9}},ExpressionUUID->"08cc2dad-6746-4e3e-ae47-\
619cd9b69027"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.41078129050290885`", ",", "0.4455746109038145`", ",", 
   "0.24543616276082025`", ",", "0.21166087312562537`", ",", 
   "0.2352356888146377`", ",", "0.306284654859372`", ",", 
   "0.4410247783570855`", ",", "0.6652084390240705`", ",", 
   "0.944160704032987`", ",", "0.8069360591489882`", ",", 
   RowBox[{"-", "0.8121873870272766`"}], ",", "0.9999870887755774`", ",", 
   "0.21612181459592303`", ",", 
   RowBox[{"-", "0.11092156824336231`"}], ",", "0.985494407323812`", ",", 
   RowBox[{"-", "0.48188256445048316`"}], ",", "0.18061548269482008`", ",", 
   RowBox[{"-", "0.2946290195254301`"}], ",", 
   RowBox[{"-", "0.17447995412400796`"}], ",", 
   RowBox[{"-", "0.6016463169847936`"}], ",", "0.9969352847843559`", ",", 
   RowBox[{"-", "0.6445031064515582`"}], ",", "0.942744377869205`", ",", 
   RowBox[{"-", "0.05502261224947945`"}], ",", "0.3955307683777889`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8608329145102725`*^9, 3.8608329223990564`*^9}, 
   3.860833076926408*^9, 3.8608340850827236`*^9, {3.860834205986665*^9, 
   3.8608342228595915`*^9}, 3.8608345942908964`*^9, {3.860834634779658*^9, 
   3.860834643012392*^9}, 3.860834968275963*^9, 3.8608355790536056`*^9, 
   3.8608358259854555`*^9, 3.8608358926730328`*^9, 3.8608359602675076`*^9, {
   3.861179173872509*^9, 3.8611792000212593`*^9}, 3.86117925351641*^9, 
   3.8611946522329874`*^9, {3.8613685510682497`*^9, 
   3.861368570263894*^9}},ExpressionUUID->"0004dec3-1c27-4ab1-bf40-\
bb5d9e44058e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"alfa", "=", 
   RowBox[{"1", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lrw", "=", "4"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"yout", ",", "w"}], "}"}], "=", 
  RowBox[{"exposmooth", "[", 
   RowBox[{"z", ",", "lrw", ",", "alfa"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "yout", "]"}], "\[IndentingNewLine]", 
 RowBox[{"zout", "=", "yout"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.860832950466874*^9, 3.860833000785946*^9}, {
   3.8608330362265787`*^9, 3.8608330628011875`*^9}, {3.860833103473442*^9, 
   3.8608331280174923`*^9}, {3.860833177889434*^9, 3.8608331844584503`*^9}, {
   3.8608336817239113`*^9, 3.8608336819146852`*^9}, {3.860833741603876*^9, 
   3.86083374246707*^9}, {3.8608338032911625`*^9, 3.8608338035710106`*^9}, {
   3.8608340636444864`*^9, 3.860834064099702*^9}, {3.8608341823886*^9, 
   3.860834182604367*^9}, {3.8608342182282195`*^9, 3.8608342184765067`*^9}, {
   3.8608346389177675`*^9, 3.8608346390534225`*^9}, 3.860835823839609*^9, {
   3.860835888760525*^9, 3.8608358891434317`*^9}, {3.860835957080603*^9, 
   3.8608359574876575`*^9}, {3.861368564915333*^9, 
   3.861368566514161*^9}},ExpressionUUID->"5cb719bc-1922-4435-bc8a-\
7e865b5d7882"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.40442244176736264`", ",", "0.4569246466297219`", ",", 
     "0.3835833722093891`", ",", "0.4429702096121666`", ",", 
     "0.4448102229571726`", ",", "0.40652184560155935`", ",", 
     "0.4371971215338659`", ",", "0.3506859145492237`", ",", 
     "0.29064000897717907`", ",", "0.18110806932824566`", ",", 
     "0.0935924850725314`", ",", "0.07587884980662005`", ",", 
     "0.0459985212686339`", ",", 
     RowBox[{"-", "0.027829159920341438`"}], ",", "0.04245785253842933`", ",", 
     RowBox[{"-", "0.014942958444416704`"}], ",", "0.07441709496487164`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.08167442225838609`", ",", "0.1016454607907402`", ",", 
     "0.11883558317985349`", ",", "0.13051535514624768`", ",", 
     "0.13465835724954514`", ",", "0.13051535514624768`", ",", 
     "0.11883558317985349`", ",", "0.1016454607907402`", ",", 
     "0.08167442225838609`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8608330642425823`*^9, 3.860833076936411*^9}, {
   3.8608331088629823`*^9, 3.8608331292475324`*^9}, 3.86083318542271*^9, 
   3.8608336826198483`*^9, 3.8608337428528805`*^9, 3.860833804422134*^9, {
   3.8608340648139906`*^9, 3.8608340850954275`*^9}, {3.8608341830236993`*^9, 
   3.8608342228729973`*^9}, 3.86083459430505*^9, {3.86083463479152*^9, 
   3.8608346430263634`*^9}, 3.8608349682879663`*^9, 3.8608355790769815`*^9, 
   3.860835826001444*^9, 3.860835892689515*^9, 3.8608359602842913`*^9, {
   3.861179173885513*^9, 3.8611792000364094`*^9}, 3.8611792535294175`*^9, 
   3.86119465224599*^9, {3.8613685510800576`*^9, 
   3.86136857027594*^9}},ExpressionUUID->"9fcaf4a9-c0d3-4ae7-8585-\
bb31e34355d9"],

Cell[BoxData["17"], "Output",
 CellChangeTimes->{{3.8608330642425823`*^9, 3.860833076936411*^9}, {
   3.8608331088629823`*^9, 3.8608331292475324`*^9}, 3.86083318542271*^9, 
   3.8608336826198483`*^9, 3.8608337428528805`*^9, 3.860833804422134*^9, {
   3.8608340648139906`*^9, 3.8608340850954275`*^9}, {3.8608341830236993`*^9, 
   3.8608342228729973`*^9}, 3.86083459430505*^9, {3.86083463479152*^9, 
   3.8608346430263634`*^9}, 3.8608349682879663`*^9, 3.8608355790769815`*^9, 
   3.860835826001444*^9, 3.860835892689515*^9, 3.8608359602842913`*^9, {
   3.861179173885513*^9, 3.8611792000364094`*^9}, 3.8611792535294175`*^9, 
   3.86119465224599*^9, {3.8613685510800576`*^9, 
   3.861368570280053*^9}},ExpressionUUID->"bb71dd59-5f7f-4fb2-9cbf-\
b7e9bb33c908"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.40442244176736264`", ",", "0.4569246466297219`", ",", 
   "0.3835833722093891`", ",", "0.4429702096121666`", ",", 
   "0.4448102229571726`", ",", "0.40652184560155935`", ",", 
   "0.4371971215338659`", ",", "0.3506859145492237`", ",", 
   "0.29064000897717907`", ",", "0.18110806932824566`", ",", 
   "0.0935924850725314`", ",", "0.07587884980662005`", ",", 
   "0.0459985212686339`", ",", 
   RowBox[{"-", "0.027829159920341438`"}], ",", "0.04245785253842933`", ",", 
   RowBox[{"-", "0.014942958444416704`"}], ",", "0.07441709496487164`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8608330642425823`*^9, 3.860833076936411*^9}, {
   3.8608331088629823`*^9, 3.8608331292475324`*^9}, 3.86083318542271*^9, 
   3.8608336826198483`*^9, 3.8608337428528805`*^9, 3.860833804422134*^9, {
   3.8608340648139906`*^9, 3.8608340850954275`*^9}, {3.8608341830236993`*^9, 
   3.8608342228729973`*^9}, 3.86083459430505*^9, {3.86083463479152*^9, 
   3.8608346430263634`*^9}, 3.8608349682879663`*^9, 3.8608355790769815`*^9, 
   3.860835826001444*^9, 3.860835892689515*^9, 3.8608359602842913`*^9, {
   3.861179173885513*^9, 3.8611792000364094`*^9}, 3.8611792535294175`*^9, 
   3.86119465224599*^9, {3.8613685510800576`*^9, 
   3.8613685702820535`*^9}},ExpressionUUID->"d75aaf86-840d-4ba4-b351-\
ec69847031d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"Table", "[", 
   RowBox[{"i", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "npts"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8608335630275297`*^9, 3.8608335829147935`*^9}, {
  3.861179164785948*^9, 
  3.861179166657276*^9}},ExpressionUUID->"3a5775f4-eaa0-43b5-a347-\
41392bd34544"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20", ",", "21", ",", 
   "22", ",", "23", ",", "24", ",", "25"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8608335839493513`*^9, 3.8608340851197395`*^9, {3.860834206026769*^9, 
   3.860834222898173*^9}, 3.860834594330885*^9, {3.860834634816566*^9, 
   3.8608346430544624`*^9}, 3.860834968314207*^9, 3.860835579100025*^9, 
   3.860835826035613*^9, 3.86083589271875*^9, 3.8608359603142796`*^9, {
   3.8611791739105883`*^9, 3.8611792000646133`*^9}, 3.861179253554204*^9, 
   3.861194652267953*^9, {3.86136855110557*^9, 
   3.8613685702956276`*^9}},ExpressionUUID->"b4d26e95-75d5-4cf0-9225-\
e6d7837c779f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exposmoothxy", "[", 
  RowBox[{"x", ",", "z", ",", "lrw", ",", "alfa"}], "]"}]], "Input",
 CellChangeTimes->{{3.860833610890954*^9, 
  3.8608336222025595`*^9}},ExpressionUUID->"40688d9f-a5f8-4074-8bad-\
f028b8be7228"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "5", ",", "6", ",", "7", ",", "8", ",", "9", ",", "10", ",", "11", ",", 
     "12", ",", "13", ",", "14", ",", "15", ",", "16", ",", "17", ",", "18", 
     ",", "19", ",", "20", ",", "21"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.40442244176736264`", ",", "0.4569246466297219`", ",", 
     "0.3835833722093891`", ",", "0.4429702096121666`", ",", 
     "0.4448102229571726`", ",", "0.40652184560155935`", ",", 
     "0.4371971215338659`", ",", "0.3506859145492237`", ",", 
     "0.29064000897717907`", ",", "0.18110806932824566`", ",", 
     "0.0935924850725314`", ",", "0.07587884980662005`", ",", 
     "0.0459985212686339`", ",", 
     RowBox[{"-", "0.027829159920341438`"}], ",", "0.04245785253842933`", ",", 
     RowBox[{"-", "0.014942958444416704`"}], ",", "0.07441709496487164`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "0.75`"}], ",", 
     RowBox[{"-", "0.5`"}], ",", 
     RowBox[{"-", "0.25`"}], ",", "0.`", ",", "0.25`", ",", "0.5`", ",", 
     "0.75`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.08167442225838609`", ",", "0.1016454607907402`", ",", 
     "0.11883558317985349`", ",", "0.13051535514624768`", ",", 
     "0.13465835724954514`", ",", "0.13051535514624768`", ",", 
     "0.11883558317985349`", ",", "0.1016454607907402`", ",", 
     "0.08167442225838609`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8608336236411815`*^9, 3.860834085128742*^9, {3.8608342060357704`*^9, 
   3.8608342229071746`*^9}, 3.860834594341157*^9, {3.8608346348266306`*^9, 
   3.860834643063464*^9}, 3.8608349683283863`*^9, 3.860835579117029*^9, 
   3.860835826053401*^9, 3.860835892735258*^9, 3.8608359603308907`*^9, {
   3.8611791739225636`*^9, 3.8611792000806246`*^9}, 3.8611792535706296`*^9, 
   3.8611946522821393`*^9, {3.8613685511182995`*^9, 
   3.8613685703086047`*^9}},ExpressionUUID->"5be7f7d0-bb14-4de5-950e-\
7e2bdd3435ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"zout", "=", "z"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"match", " ", "the", " ", "size", " ", "of", " ", "z"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lz", "=", 
   RowBox[{"Length", "[", "z", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "L1", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yout", ",", "w"}], "}"}], "=", 
     RowBox[{"exposmooth", "[", 
      RowBox[{"z", ",", "L1", ",", "alfa"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Length", "[", "yout", "]"}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "yout", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"zout", "[", 
        RowBox[{"[", 
         RowBox[{"i", "+", "L1"}], "]"}], "]"}], "=", 
       RowBox[{"yout", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "yout", "]"}]}], "}"}]}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "zout", "]"}], ";"}], "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"L1", ",", "1", ",", "lrw"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "zout", "]"}], "\[IndentingNewLine]", 
 RowBox[{"pts", "=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"x", ",", "zout"}], "}"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.860834846358314*^9, 3.860834908085422*^9}, {
   3.8608349435496955`*^9, 3.860834959990596*^9}, {3.860835011606764*^9, 
   3.8608350796783676`*^9}, {3.86083512032701*^9, 3.860835134958838*^9}, {
   3.8608351677420626`*^9, 3.860835226414962*^9}, 3.8608352771032066`*^9, {
   3.8608353261829753`*^9, 3.8608354625840197`*^9}, {3.860835504521559*^9, 
   3.8608355617828827`*^9}, {3.8608356068078732`*^9, 
   3.8608356136954966`*^9}, {3.860835665159793*^9, 3.860835707576109*^9}, {
   3.860836018520503*^9, 3.860836030232745*^9}, 3.860836103378185*^9, {
   3.8611791916021757`*^9, 3.8611791950664587`*^9}, {3.861194630336377*^9, 
   3.8611946836726446`*^9}, {3.861368546524004*^9, 3.861368546528352*^9}, 
   3.861368583850969*^9},ExpressionUUID->"a13ca7e8-55d1-4d9d-8fa6-\
0779d03cfbf8"],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.861368585601338*^9}},ExpressionUUID->"511133c1-c0c2-4a6c-b4ae-\
707ca1c75dbe"],

Cell[BoxData["23"], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.8613685856055665`*^9}},ExpressionUUID->"cd6eaa1f-7e34-4088-a1aa-\
2b2037580684"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.3811871855253831`", ",", "0.29103108387571186`", ",", 
   "0.22737873729484506`", ",", "0.24824686364373408`", ",", 
   "0.32374040242891927`", ",", "0.4655384450730166`", ",", 
   "0.6802187947839727`", ",", "0.8300996730534795`", ",", 
   "0.4007941010903737`", ",", "0.12822369603709538`", ",", 
   "0.28849405946989626`", ",", "0.34132235951250217`", ",", 
   "0.2792039724048336`", ",", "0.2828392146870993`", ",", 
   "0.10184934075775197`", ",", 
   RowBox[{"-", "0.1312040466569629`"}], ",", 
   RowBox[{"-", "0.13145032664943895`"}], ",", 
   RowBox[{"-", "0.3244819377387189`"}], ",", 
   RowBox[{"-", "0.046452369752636766`"}], ",", "0.10894747957078901`", ",", 
   "0.24037837284465205`", ",", "0.2342730306063797`", ",", 
   "0.3419165517190647`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.861368585609813*^9}},ExpressionUUID->"5104656c-0155-47e1-9207-\
8e8284bb7914"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.41078129050290885`", ",", "0.3811871855253831`", ",", 
   "0.29103108387571186`", ",", "0.22737873729484506`", ",", 
   "0.24824686364373408`", ",", "0.32374040242891927`", ",", 
   "0.4655384450730166`", ",", "0.6802187947839727`", ",", 
   "0.8300996730534795`", ",", "0.4007941010903737`", ",", 
   "0.12822369603709538`", ",", "0.28849405946989626`", ",", 
   "0.34132235951250217`", ",", "0.2792039724048336`", ",", 
   "0.2828392146870993`", ",", "0.10184934075775197`", ",", 
   RowBox[{"-", "0.1312040466569629`"}], ",", 
   RowBox[{"-", "0.13145032664943895`"}], ",", 
   RowBox[{"-", "0.3244819377387189`"}], ",", 
   RowBox[{"-", "0.046452369752636766`"}], ",", "0.10894747957078901`", ",", 
   "0.24037837284465205`", ",", "0.2342730306063797`", ",", 
   "0.3419165517190647`", ",", "0.3955307683777889`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.861368585610813*^9}},ExpressionUUID->"d73f2734-1b24-4fff-99fb-\
c14b8266b491"],

Cell[BoxData["2"], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.8613685856118135`*^9}},ExpressionUUID->"7f9347bf-da61-4efd-836d-\
f557434d91ca"],

Cell[BoxData["21"], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.861368585612814*^9}},ExpressionUUID->"4aae32f8-912c-44ee-bd66-\
a750b8ed9613"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.30599715393853855`", ",", "0.2744753291688693`", ",", 
   "0.2786991596968289`", ",", "0.36071157887864386`", ",", 
   "0.5062032661031578`", ",", "0.644242663950763`", ",", 
   "0.5073338852075403`", ",", "0.486014945520467`", ",", 
   "0.37359050318667836`", ",", "0.22526465009644386`", ",", 
   "0.2779839316898321`", ",", "0.31767968644326916`", ",", 
   "0.17671447705546128`", ",", "0.07572216235909493`", ",", 
   RowBox[{"-", "0.003204695070816364`"}], ",", 
   RowBox[{"-", "0.23790719137837002`"}], ",", 
   RowBox[{"-", "0.06315134173476153`"}], ",", 
   RowBox[{"-", "0.11197543752851054`"}], ",", "0.09129793198859744`", ",", 
   "0.16816467545896271`", ",", "0.29411066841574574`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.8613685856138144`*^9}},ExpressionUUID->"32826c53-ff96-48e4-92e5-\
c33a023ae414"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.41078129050290885`", ",", "0.3811871855253831`", ",", 
   "0.30599715393853855`", ",", "0.2744753291688693`", ",", 
   "0.2786991596968289`", ",", "0.36071157887864386`", ",", 
   "0.5062032661031578`", ",", "0.644242663950763`", ",", 
   "0.5073338852075403`", ",", "0.486014945520467`", ",", 
   "0.37359050318667836`", ",", "0.22526465009644386`", ",", 
   "0.2779839316898321`", ",", "0.31767968644326916`", ",", 
   "0.17671447705546128`", ",", "0.07572216235909493`", ",", 
   RowBox[{"-", "0.003204695070816364`"}], ",", 
   RowBox[{"-", "0.23790719137837002`"}], ",", 
   RowBox[{"-", "0.06315134173476153`"}], ",", 
   RowBox[{"-", "0.11197543752851054`"}], ",", "0.09129793198859744`", ",", 
   "0.16816467545896271`", ",", "0.29411066841574574`", ",", 
   "0.3419165517190647`", ",", "0.3955307683777889`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.861368585615814*^9}},ExpressionUUID->"742db7fd-b07c-431c-a52e-\
57e7d72bca06"],

Cell[BoxData["3"], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.8613685856168146`*^9}},ExpressionUUID->"28b1e5bd-659c-4257-a1f0-\
cd844c194811"],

Cell[BoxData["19"], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.861368585617815*^9}},ExpressionUUID->"263c2f6e-315c-47ac-8fc4-\
f1d4ad80d0d4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.3128115924071292`", ",", "0.3414712060495522`", ",", 
   "0.41526107700016607`", ",", "0.5120893639092904`", ",", 
   "0.44107879650891035`", ",", "0.49625201276159364`", ",", 
   "0.4667944174452257`", ",", "0.3789326722912822`", ",", 
   "0.3791939156757499`", ",", "0.24412180079321094`", ",", 
   "0.18532637349131778`", ",", "0.20507116940542194`", ",", 
   "0.05637960256320173`", ",", 
   RowBox[{"-", "0.05900645176305956`"}], ",", "0.00805355124983249`", ",", 
   RowBox[{"-", "0.13363788687086647`"}], ",", "0.018525874191555255`", ",", 
   "0.03876873822712478`", ",", "0.13994852346732156`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.8613685856188145`*^9}},ExpressionUUID->"fc872751-13ef-44dd-8708-\
3bcde3b8eb55"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.41078129050290885`", ",", "0.3811871855253831`", ",", 
   "0.30599715393853855`", ",", "0.3128115924071292`", ",", 
   "0.3414712060495522`", ",", "0.41526107700016607`", ",", 
   "0.5120893639092904`", ",", "0.44107879650891035`", ",", 
   "0.49625201276159364`", ",", "0.4667944174452257`", ",", 
   "0.3789326722912822`", ",", "0.3791939156757499`", ",", 
   "0.24412180079321094`", ",", "0.18532637349131778`", ",", 
   "0.20507116940542194`", ",", "0.05637960256320173`", ",", 
   RowBox[{"-", "0.05900645176305956`"}], ",", "0.00805355124983249`", ",", 
   RowBox[{"-", "0.13363788687086647`"}], ",", "0.018525874191555255`", ",", 
   "0.03876873822712478`", ",", "0.13994852346732156`", ",", 
   "0.29411066841574574`", ",", "0.3419165517190647`", ",", 
   "0.3955307683777889`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.8613685856208153`*^9}},ExpressionUUID->"4adee2f4-4f01-41c1-b7c7-\
091f5d8cb25e"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.8613685856218157`*^9}},ExpressionUUID->"c4a79eca-659b-4aaf-a58a-\
21a65fff0c67"],

Cell[BoxData["17"], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.861368585622816*^9}},ExpressionUUID->"31a5e8a8-90b5-44d1-92b1-\
cf723a4fe2da"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.40442244176736264`", ",", "0.4569246466297219`", ",", 
   "0.3835833722093891`", ",", "0.4429702096121666`", ",", 
   "0.4448102229571726`", ",", "0.40652184560155935`", ",", 
   "0.4371971215338659`", ",", "0.3506859145492237`", ",", 
   "0.29064000897717907`", ",", "0.18110806932824566`", ",", 
   "0.0935924850725314`", ",", "0.07587884980662005`", ",", 
   "0.0459985212686339`", ",", 
   RowBox[{"-", "0.027829159920341438`"}], ",", "0.04245785253842933`", ",", 
   RowBox[{"-", "0.014942958444416704`"}], ",", "0.07441709496487164`"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.8613685856238165`*^9}},ExpressionUUID->"bacf94f8-31ce-467c-a2e5-\
b2d39bfc7c7a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.41078129050290885`", ",", "0.3811871855253831`", ",", 
   "0.30599715393853855`", ",", "0.3128115924071292`", ",", 
   "0.40442244176736264`", ",", "0.4569246466297219`", ",", 
   "0.3835833722093891`", ",", "0.4429702096121666`", ",", 
   "0.4448102229571726`", ",", "0.40652184560155935`", ",", 
   "0.4371971215338659`", ",", "0.3506859145492237`", ",", 
   "0.29064000897717907`", ",", "0.18110806932824566`", ",", 
   "0.0935924850725314`", ",", "0.07587884980662005`", ",", 
   "0.0459985212686339`", ",", 
   RowBox[{"-", "0.027829159920341438`"}], ",", "0.04245785253842933`", ",", 
   RowBox[{"-", "0.014942958444416704`"}], ",", "0.07441709496487164`", ",", 
   "0.13994852346732156`", ",", "0.29411066841574574`", ",", 
   "0.3419165517190647`", ",", "0.3955307683777889`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.8613685856258163`*^9}},ExpressionUUID->"86fd2ded-0fcd-4e24-94f8-\
2997679d7c70"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.41078129050290885`", ",", "0.3811871855253831`", ",", 
   "0.30599715393853855`", ",", "0.3128115924071292`", ",", 
   "0.40442244176736264`", ",", "0.4569246466297219`", ",", 
   "0.3835833722093891`", ",", "0.4429702096121666`", ",", 
   "0.4448102229571726`", ",", "0.40652184560155935`", ",", 
   "0.4371971215338659`", ",", "0.3506859145492237`", ",", 
   "0.29064000897717907`", ",", "0.18110806932824566`", ",", 
   "0.0935924850725314`", ",", "0.07587884980662005`", ",", 
   "0.0459985212686339`", ",", 
   RowBox[{"-", "0.027829159920341438`"}], ",", "0.04245785253842933`", ",", 
   RowBox[{"-", "0.014942958444416704`"}], ",", "0.07441709496487164`", ",", 
   "0.13994852346732156`", ",", "0.29411066841574574`", ",", 
   "0.3419165517190647`", ",", "0.3955307683777889`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.8611792000926266`*^9, 3.861179253587634*^9, {3.8611946522991433`*^9, 
   3.8611946839009542`*^9}, {3.8613685511326494`*^9, 
   3.8613685856268167`*^9}},ExpressionUUID->"8b3f1e74-a6c8-4f8c-94e6-\
56190556e49e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0.41078129050290885`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0.3811871855253831`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0.30599715393853855`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0.3128115924071292`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0.40442244176736264`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0.4569246466297219`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0.3835833722093891`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0.4429702096121666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "0.4448102229571726`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0.40652184560155935`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "0.4371971215338659`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "0.3506859145492237`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "0.29064000897717907`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "0.18110806932824566`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "0.0935924850725314`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "0.07587884980662005`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "0.0459985212686339`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", 
     RowBox[{"-", "0.027829159920341438`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "0.04245785253842933`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", 
     RowBox[{"-", "0.014942958444416704`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "0.07441709496487164`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "0.13994852346732156`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "0.29411066841574574`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "0.3419165517190647`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "0.3955307683777889`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8608351790590353`*^9, {3.8608354425686812`*^9, 3.8608354638577576`*^9}, 
   3.8608355268461113`*^9, {3.860835562512745*^9, 3.8608355791358795`*^9}, 
   3.860835614044757*^9, 3.86083567355669*^9, 3.8608357083724995`*^9, 
   3.8608358260699415`*^9, 3.860835892752265*^9, 3.8608359603479004`*^9, {
   3.861179173935802*^9, 3.8611792000896263`*^9}, 3.8611792535836334`*^9, {
   3.8611946522951427`*^9, 3.8611946838962517`*^9}, {3.861368551130302*^9, 
   3.861368585628817*^9}},ExpressionUUID->"3f8984b2-d680-4b82-a2b8-\
5f969baa3174"]
}, Open  ]]
},
WindowSize->{1920, 1007},
WindowMargins->{{Automatic, 165}, {4, Automatic}},
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 3118, 77, 181, "Input",ExpressionUUID->"35c10509-c0d9-46f3-b5c0-d52cb7e365d7"],
Cell[3679, 99, 4069, 101, 200, "Input",ExpressionUUID->"75a45e71-e0f4-4c5a-9015-e810eddac226"],
Cell[7751, 202, 236, 6, 48, "Input",ExpressionUUID->"02bebe18-06b1-4c33-9e74-554774b981fe"],
Cell[CellGroupData[{
Cell[8012, 212, 545, 14, 28, "Input",ExpressionUUID->"08cc2dad-6746-4e3e-ae47-619cd9b69027"],
Cell[8560, 228, 1514, 26, 32, "Output",ExpressionUUID->"0004dec3-1c27-4ab1-bf40-bb5d9e44058e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10111, 259, 1334, 26, 143, "Input",ExpressionUUID->"5cb719bc-1922-4435-bc8a-7e865b5d7882"],
Cell[11448, 287, 1720, 32, 52, "Output",ExpressionUUID->"9fcaf4a9-c0d3-4ae7-8585-bb31e34355d9"],
Cell[13171, 321, 756, 11, 32, "Output",ExpressionUUID->"bb71dd59-5f7f-4fb2-9cbf-b7e9bb33c908"],
Cell[13930, 334, 1337, 23, 32, "Output",ExpressionUUID->"d75aaf86-840d-4ba4-b351-ec69847031d2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15304, 362, 348, 9, 28, "Input",ExpressionUUID->"3a5775f4-eaa0-43b5-a347-41392bd34544"],
Cell[15655, 373, 854, 15, 32, "Output",ExpressionUUID->"b4d26e95-75d5-4cf0-9225-e6d7837c779f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16546, 393, 241, 5, 28, "Input",ExpressionUUID->"40688d9f-a5f8-4074-8bad-f028b8be7228"],
Cell[16790, 400, 2011, 42, 52, "Output",ExpressionUUID->"5be7f7d0-bb14-4de5-950e-7e2bdd3435ec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18838, 447, 2366, 55, 219, "Input",ExpressionUUID->"a13ca7e8-55d1-4d9d-8fa6-0779d03cfbf8"],
Cell[CellGroupData[{
Cell[21229, 506, 259, 5, 22, "Print",ExpressionUUID->"511133c1-c0c2-4a6c-b4ae-707ca1c75dbe"],
Cell[21491, 513, 262, 5, 22, "Print",ExpressionUUID->"cd6eaa1f-7e34-4088-a1aa-2b2037580684"],
Cell[21756, 520, 1056, 21, 22, "Print",ExpressionUUID->"5104656c-0155-47e1-9207-8e8284bb7914"],
Cell[22815, 543, 1113, 21, 22, "Print",ExpressionUUID->"d73f2734-1b24-4fff-99fb-c14b8266b491"],
Cell[23931, 566, 261, 5, 22, "Print",ExpressionUUID->"7f9347bf-da61-4efd-836d-f557434d91ca"],
Cell[24195, 573, 260, 5, 22, "Print",ExpressionUUID->"4aae32f8-912c-44ee-bd66-a750b8ed9613"],
Cell[24458, 580, 994, 19, 22, "Print",ExpressionUUID->"32826c53-ff96-48e4-92e5-c33a023ae414"],
Cell[25455, 601, 1113, 21, 22, "Print",ExpressionUUID->"742db7fd-b07c-431c-a52e-57e7d72bca06"],
Cell[26571, 624, 261, 5, 22, "Print",ExpressionUUID->"28b1e5bd-659c-4257-a1f0-cd844c194811"],
Cell[26835, 631, 260, 5, 22, "Print",ExpressionUUID->"263c2f6e-315c-47ac-8fc4-f1d4ad80d0d4"],
Cell[27098, 638, 901, 17, 22, "Print",ExpressionUUID->"fc872751-13ef-44dd-8708-3bcde3b8eb55"],
Cell[28002, 657, 1084, 20, 22, "Print",ExpressionUUID->"4adee2f4-4f01-41c1-b7c7-091f5d8cb25e"],
Cell[29089, 679, 261, 5, 22, "Print",ExpressionUUID->"c4a79eca-659b-4aaf-a58a-21a65fff0c67"],
Cell[29353, 686, 260, 5, 22, "Print",ExpressionUUID->"31a5e8a8-90b5-44d1-92b1-cf723a4fe2da"],
Cell[29616, 693, 841, 17, 22, "Print",ExpressionUUID->"bacf94f8-31ce-467c-a2e5-b2d39bfc7c7a"],
Cell[30460, 712, 1082, 20, 22, "Print",ExpressionUUID->"86fd2ded-0fcd-4e24-94f8-2997679d7c70"],
Cell[31545, 734, 1082, 20, 22, "Print",ExpressionUUID->"8b3f1e74-a6c8-4f8c-94e6-56190556e49e"]
}, Open  ]],
Cell[32642, 757, 2606, 63, 109, "Output",ExpressionUUID->"3f8984b2-d680-4b82-a2b8-5f969baa3174"]
}, Open  ]]
}
]
*)

